#
# External API for shopping cart.
#
module CartExternal
  class API < Grape::API

    version 'v1', :using => :path
    format :json

    #
    # Helper methods
    #-------------------------------
    helpers do

      def is_valid_api_key?(key)
        key == 'API_KEY' # Replace this with a proper API key or API key/secret pair
      end

      def find_or_create_cart(token)
        ShoppingCart.find_or_create_with token
      end

    end

    #
    # Shopping cart methods
    #---------------------------------
    resource :cart do

      desc 'Return items in cart.'
      params do
        optional :token, type: String, default: nil
        requires :key, type: String
      end
      get '/items' do
        if is_valid_api_key? params[:key]
          token = params[:token]

          cart = ShoppingCart.find_or_create_with token

          response = {
            status: 200,
            token: cart.token,
            cart: cart.as_json
          }

          response.as_json
        else
          error!('401 Unauthorized', 401)
        end
      end

    end
  end
end